#ifndef _CANVAS_H_
#define _CANVAS_H_

//~~~~~~~~~~~~~~~~~~~~
#include <StdColor.h>
//~~~~~~~~~~~~~~~~~~~~

typedef UINT32 POINT;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                                   TCanvas
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
class TCanvas
{
public:

  //*** UI-Editor Parameters
  INT8  charw;
  INT8  charh;

  //***
  INT32 penw;
  INT32 penh;
  INT32 dwell;

  INT32 offsetx;
  INT32 offsety;
  INT32 spacex;
  INT32 spacey;
  INT32 deltax;
  INT32 deltay;
  INT32 cycles;
  INT32 levelred;
  INT32 levelgreen;
  INT32 levelblue;

  bool   tboxEnabled;
  char   tboxColorText[20];
  double tboxScaleX;
  double tboxScaleY;
  INT32  tboxDisplay;
  INT32  tboxInformation;
  
  INT32 x;
  INT32 y;
  INT32 width;
  INT32 height;

  double ctm[3][3];
  double aspect;
  double aspectSize;
  double aspectPixel;
  double normalwidth;
  double normalheight;

  UINT8  unitSize;
	double widthSize;
  double heightSize;
  INT32  meterWidth;
  INT32  meterHeight;

  INT32 left;
  INT32 top;
  INT32 right;
  INT32 bottom;
  INT32 centerleft;
  INT32 centertop;
  INT32 centerright;
  INT32 centerbottom;

  INT32 major;
  INT32 minor;

  INT32 addSpace;
  INT32 modSpace;

  TColor background;
  TColor foreground;

  
  // Additive increment to horiz. spacing between text char images
  INT32 addtext;

  // Width and height of rectangular drawing pen
  POINT pensize;

  // Coordinate origin
  POINT xyorigin;

  // Concatenation of screen x and y dimen's
  POINT screensize;

  UINT32 scrn_offset;
  UINT32 scrn_pitch;
};

#endif
